/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class Months
extends TimeUnit {
    protected boolean fEveryMonth;
    static final long serialVersionUID = 0L;
    private int minutesSerializedDataVersion = 1;
    public static final int[] DAYS_PER_MONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int ERR_MONTH = 1;
    public static final int ERR_DAY = 2;
    public static final String UNIT_KEY = "dialog.timeParameter.months";
    public static final String DEFAULT_UNIT_STRING = "month.day";
    public static final String UNIT_ABBREVIATION = "MM.DD";

    public String getParameterText() {
        return this.getTimeAsString();
    }

    public boolean isEveryMonth() {
        return this.fEveryMonth;
    }

    public void setEveryMonth(boolean state) {
        this.fEveryMonth = state;
    }

    public Months() {
        this.fHighMin = 1;
        this.fHighMax = 12;
        this.fHighInc = 1;
        this.fLowMin = 1;
        this.fLowMax = 31;
        this.fLowInc = 1;
        this.setTime(1, 1);
    }

    public int checkDate(int month, int day) {
        if (month < 1 || month > 12) {
            return 1;
        }
        if (day < 1 || day > 31 || day > DAYS_PER_MONTH[month - 1]) {
            return 2;
        }
        return 0;
    }

    public int compare(Months other) {
        if (this.fTime < other.fTime) {
            return -1;
        }
        if (this.fTime > other.fTime) {
            return 1;
        }
        return 0;
    }

    public int compareWith(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        long today = gregorianCalendar.get(2) + 1;
        today <<= 8;
        if (this.fTime < (today += (long)gregorianCalendar.get(5))) {
            return -1;
        }
        if (this.fTime > today) {
            return 1;
        }
        return 0;
    }

    public String getTimeAsStringLong() {
        return this.getTimeAsString() + " " + Language.getString(this.getUnitKey(), this.getDefaultUnitString());
    }

    public String getDefaultUnitString() {
        return DEFAULT_UNIT_STRING;
    }

    public IntValueProperties getHigh() {
        return new IntValueProperties(this.fHighMin, this.fHighMax, this.fHighInc, this.getHighValue(), "error.dialog.invalidValue", "Invalid Value for Month.");
    }

    public int getHighValue() {
        return (int)(this.fTime >> 8);
    }

    public int[] getLogoTime() {
        int[] lTime = new int[]{this.getHighValue(), this.getLowValue()};
        return lTime;
    }

    public IntValueProperties getLow() {
        return new IntValueProperties(this.fLowMin, this.fLowMax, this.fLowInc, this.getLowValue(), "error.dialog.invalidValue", "Invalid Value for day.");
    }

    public int getLowValue() {
        return (int)(this.fTime & 0xFFL);
    }

    public int getTimeValue() {
        return this.getHighValue() << 8 + this.getLowValue();
    }

    public String getTimeAsString() {
        String high = "00" + String.valueOf(this.getHighValue());
        String low = "00" + String.valueOf(this.getLowValue());
        high = high.substring(high.length() - 2);
        low = low.substring(low.length() - 2);
        StringBuffer buffer = new StringBuffer(high).append('.').append(low);
        if (this.isEveryMonth()) {
            buffer.replace(0, 2, "**");
        }
        return buffer.toString();
    }

    public String getUnitAbbreviation() {
        return UNIT_ABBREVIATION;
    }

    public String getUnitKey() {
        return UNIT_KEY;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fEveryMonth = dr.readBoolean();
    }

    public void setTime(int high, int low) {
        if (high == 255) {
            high = 1;
            this.setEveryMonth(true);
        }
        this.fTime = (high << 8) + low;
    }

    public TimeUnit setTime(int value) {
        value = Util.getValueInRange(1, 31, value);
        this.setTime(0, value);
        return this;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.fEveryMonth);
    }

    public String getLowValueUnitKey() {
        return "dialog.timeParameter.days";
    }

    public String getLowValueUnitAbbreviation() {
        return "d";
    }

    public String getBCDString() {
        if (this.isEveryMonth()) {
            String low = String.valueOf(this.getLowValue());
            if (low.length() < 2) {
                low = "0" + low;
            }
            return Integer.toBinaryString(Integer.parseInt("FF" + low, 16));
        }
        return super.getBCDString();
    }
}

